package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.utils.Dictionary;
	

	public class MainClass extends Sprite
	{
		private const criteriaCount:int=5;
		private const maxAge:int=100;//in terms of days
		public static var isCircularMode:Boolean;
		
		public var allRanks:Array = new Array();
		public var allRelevances:Array = new Array();
		public var allIcons:Array = new Array();
		private var externalXML:XML; 
		private var map:Dictionary = new Dictionary();
		
		public function MainClass()
		{
			super();
			trace("in constructor:main")
			var loader:URLLoader = new URLLoader(); 
			var request:URLRequest = new URLRequest("search1.xml"); 
			loader.load(request); 
			loader.addEventListener(Event.COMPLETE, onComplete); 			
			
		}//end of constructor
		
		public function onComplete(event:Event):void 
		{ 
			var i:int=0;
			var loader:URLLoader = event.target as URLLoader; 
			
			if (loader != null) 
			{ 
				externalXML = new XML(loader.data); 
				for (var prop:String in externalXML.child("guitar")) 
				{
					//we are filling rank values for a specific icon-> may change for increasing readability
					var xmlChildren:XMLList;
					var startIndex:int=4;
					var iconRanks:Array = new Array(criteriaCount);
					var iconInfo:Array = new Array();
					
					xmlChildren= externalXML.child("guitar")[prop].children();
					startIndex = xmlChildren.length()- criteriaCount;
						
					var relevance:Number = externalXML.child("guitar")[prop].child("relevance");
					var timeToEnd:Number = externalXML.child("guitar")[prop].child("timetoend");
					var bidRate:Number = externalXML.child("guitar")[prop].child("bidrate");
					var age:int = maxAge-timeToEnd;
					trace("age"+age);
					//reading icon ranks from xml
					for (var k:int=0; k<criteriaCount; k++)
						iconRanks[k] = parseInt(xmlChildren[startIndex+k].attribute("rank"));
					
					allRanks[prop] = iconRanks;
					allRelevances[prop] = relevance;
					
					//reading iconInfo from xml and storing it for showing it to user later
					var info:String;
					var subStrings:Array = new Array();
					for(var propIndex in xmlChildren)
					{
						subStrings = xmlChildren[propIndex].toXMLString().split(/\s+/);
						info= subStrings[0].slice(1,subStrings[0].length);
						subStrings=info.split(">");
						iconInfo[propIndex]= subStrings[0]+"="+xmlChildren[propIndex];
						
					}
					
					//for each result, create icon and store in an array
					allIcons[prop]= new ResultIcon(relevance,age,bidRate,iconRanks,iconInfo,MainClass.isCircularMode,maxAge,criteriaCount);
				}//end of for (reading all search results)

			} //end of if 
			else 
			{ 
				trace("loader is not a URLLoader!"); 
			} 
		}//end of function (onComplete)

	}//end of class
}//end of package
